function [residual, g1, g2, g3] = World_Economy_Cartel_dAC_objective_static(y, x, params)
%
% Status : Computes static model for Dynare
%
% Inputs : 
%   y         [M_.endo_nbr by 1] double    vector of endogenous variables in declaration order
%   x         [M_.exo_nbr by 1] double     vector of exogenous variables in declaration order
%   params    [M_.param_nbr by 1] double   vector of parameter values in declaration order
%
% Outputs:
%   residual  [M_.endo_nbr by 1] double    vector of residuals of the static model equations 
%                                          in order of declaration of the equations.
%                                          Dynare may prepend or append auxiliary equations, see M_.aux_vars
%   g1        [M_.endo_nbr by M_.endo_nbr] double    Jacobian matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%   g2        [M_.endo_nbr by (M_.endo_nbr)^2] double   Hessian matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%   g3        [M_.endo_nbr by (M_.endo_nbr)^3] double   Third derivatives matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%
%
% Warning : this file is generated automatically by Dynare
%           from model file (.mod)

residual = zeros( 1, 1);

%
% Model equations
%

T18 = exp(y(19))-params(9)*exp(y(18))^(1+params(8))/(1+params(8));
T21 = T18^(-params(14));
T31 = exp(y(31)-y(24));
T37 = exp(y(4))*exp(y(1))-exp(y(4))*params(6)*T31^(params(5)-1);
residual(1) = T21*(T37-exp(y(2)));
if ~isreal(residual)
  residual = real(residual)+imag(residual).^2;
end
if nargout >= 2,
  g1 = zeros(1, 70);

  %
  % Jacobian matrix
  %

T48 = exp(y(18))*getPowerDeriv(exp(y(18)),1+params(8),1);
T51 = (-(params(9)*T48/(1+params(8))));
T52 = getPowerDeriv(T18,(-params(14)),1);
T53 = T51*T52;
T58 = getPowerDeriv(T31,params(5)-1,1);
T62 = (-(exp(y(4))*params(6)*(-T31)*T58));
T67 = (-(exp(y(4))*params(6)*T31*T58));
  g1(1,1)=T21*exp(y(4))*exp(y(1));
  g1(1,2)=T21*(-exp(y(2)));
  g1(1,4)=T21*T37;
  g1(1,18)=(T37-exp(y(2)))*T53;
  g1(1,19)=(T37-exp(y(2)))*exp(y(19))*T52;
  g1(1,24)=T21*T62;
  g1(1,31)=T21*T67;
  if ~isreal(g1)
    g1 = real(g1)+2*imag(g1);
  end
if nargout >= 3,
  %
  % Hessian matrix
  %

  v2 = zeros(37,3);
T73 = exp(y(18))*getPowerDeriv(exp(y(18)),1+params(8),2);
T74 = exp(y(18))*T73;
T75 = T48+T74;
T78 = (-(params(9)*T75/(1+params(8))));
T79 = getPowerDeriv(T18,(-params(14)),2);
T80 = T51*T79;
T83 = T52*T78+T51*T80;
T92 = exp(y(19))*T52+exp(y(19))*exp(y(19))*T79;
T96 = getPowerDeriv(T31,params(5)-1,2);
T97 = (-T31)*T96;
T102 = (-(exp(y(4))*params(6)*(T31*T58+(-T31)*T97)));
T110 = (-(exp(y(4))*params(6)*((-T31)*T58+T31*T97)));
T117 = (-(exp(y(4))*params(6)*(T31*T58+T31*T31*T96)));
  v2(1,1)=1;
  v2(1,2)=1;
  v2(1,3)=T21*exp(y(4))*exp(y(1));
  v2(2,1)=1;
  v2(2,2)=72;
  v2(2,3)=T21*(-exp(y(2)));
  v2(3,1)=1;
  v2(3,2)=211;
  v2(3,3)=T21*exp(y(4))*exp(y(1));
  v2(4,1)=1;
  v2(4,2)=4;
  v2(4,3)=  v2(3,3);
  v2(5,1)=1;
  v2(5,2)=214;
  v2(5,3)=T21*T37;
  v2(6,1)=1;
  v2(6,2)=1191;
  v2(6,3)=exp(y(4))*exp(y(1))*T53;
  v2(7,1)=1;
  v2(7,2)=18;
  v2(7,3)=  v2(6,3);
  v2(8,1)=1;
  v2(8,2)=1192;
  v2(8,3)=(-exp(y(2)))*T53;
  v2(9,1)=1;
  v2(9,2)=88;
  v2(9,3)=  v2(8,3);
  v2(10,1)=1;
  v2(10,2)=1194;
  v2(10,3)=T37*T53;
  v2(11,1)=1;
  v2(11,2)=228;
  v2(11,3)=  v2(10,3);
  v2(12,1)=1;
  v2(12,2)=1208;
  v2(12,3)=(T37-exp(y(2)))*T83;
  v2(13,1)=1;
  v2(13,2)=1261;
  v2(13,3)=exp(y(4))*exp(y(1))*exp(y(19))*T52;
  v2(14,1)=1;
  v2(14,2)=19;
  v2(14,3)=  v2(13,3);
  v2(15,1)=1;
  v2(15,2)=1262;
  v2(15,3)=(-exp(y(2)))*exp(y(19))*T52;
  v2(16,1)=1;
  v2(16,2)=89;
  v2(16,3)=  v2(15,3);
  v2(17,1)=1;
  v2(17,2)=1264;
  v2(17,3)=T37*exp(y(19))*T52;
  v2(18,1)=1;
  v2(18,2)=229;
  v2(18,3)=  v2(17,3);
  v2(19,1)=1;
  v2(19,2)=1278;
  v2(19,3)=(T37-exp(y(2)))*exp(y(19))*T80;
  v2(20,1)=1;
  v2(20,2)=1209;
  v2(20,3)=  v2(19,3);
  v2(21,1)=1;
  v2(21,2)=1279;
  v2(21,3)=(T37-exp(y(2)))*T92;
  v2(22,1)=1;
  v2(22,2)=1614;
  v2(22,3)=T21*T62;
  v2(23,1)=1;
  v2(23,2)=234;
  v2(23,3)=  v2(22,3);
  v2(24,1)=1;
  v2(24,2)=1628;
  v2(24,3)=T53*T62;
  v2(25,1)=1;
  v2(25,2)=1214;
  v2(25,3)=  v2(24,3);
  v2(26,1)=1;
  v2(26,2)=1629;
  v2(26,3)=exp(y(19))*T52*T62;
  v2(27,1)=1;
  v2(27,2)=1284;
  v2(27,3)=  v2(26,3);
  v2(28,1)=1;
  v2(28,2)=1634;
  v2(28,3)=T21*T102;
  v2(29,1)=1;
  v2(29,2)=2104;
  v2(29,3)=T21*T67;
  v2(30,1)=1;
  v2(30,2)=241;
  v2(30,3)=  v2(29,3);
  v2(31,1)=1;
  v2(31,2)=2118;
  v2(31,3)=T53*T67;
  v2(32,1)=1;
  v2(32,2)=1221;
  v2(32,3)=  v2(31,3);
  v2(33,1)=1;
  v2(33,2)=2119;
  v2(33,3)=exp(y(19))*T52*T67;
  v2(34,1)=1;
  v2(34,2)=1291;
  v2(34,3)=  v2(33,3);
  v2(35,1)=1;
  v2(35,2)=2124;
  v2(35,3)=T21*T110;
  v2(36,1)=1;
  v2(36,2)=1641;
  v2(36,3)=  v2(35,3);
  v2(37,1)=1;
  v2(37,2)=2131;
  v2(37,3)=T21*T117;
  g2 = sparse(v2(:,1),v2(:,2),v2(:,3),1,4900);
if nargout >= 4,
  %
  % Third order derivatives
  %

  v3 = zeros(181,3);
T135 = getPowerDeriv(T18,(-params(14)),3);
T136 = T51*T135;
T139 = T78*T79+T51*T136;
T168 = getPowerDeriv(T31,params(5)-1,3);
T169 = (-T31)*T168;
T171 = T31*T96+(-T31)*T169;
  v3(1,1)=1;
  v3(1,2)=1;
  v3(1,3)=T21*exp(y(4))*exp(y(1));
  v3(2,1)=1;
  v3(2,2)=4972;
  v3(2,3)=T21*(-exp(y(2)));
  v3(3,1)=1;
  v3(3,2)=14701;
  v3(3,3)=T21*exp(y(4))*exp(y(1));
  v3(4,1)=1;
  v3(4,2)=4;
  v3(4,3)=  v3(3,3);
  v3(5,1)=1;
  v3(5,2)=211;
  v3(5,3)=  v3(3,3);
  v3(6,1)=1;
  v3(6,2)=14911;
  v3(6,3)=T21*exp(y(4))*exp(y(1));
  v3(7,1)=1;
  v3(7,2)=214;
  v3(7,3)=  v3(6,3);
  v3(8,1)=1;
  v3(8,2)=14704;
  v3(8,3)=  v3(6,3);
  v3(9,1)=1;
  v3(9,2)=14914;
  v3(9,3)=T21*T37;
  v3(10,1)=1;
  v3(10,2)=83301;
  v3(10,3)=exp(y(4))*exp(y(1))*T53;
  v3(11,1)=1;
  v3(11,2)=18;
  v3(11,3)=  v3(10,3);
  v3(12,1)=1;
  v3(12,2)=1191;
  v3(12,3)=  v3(10,3);
  v3(13,1)=1;
  v3(13,2)=83372;
  v3(13,3)=(-exp(y(2)))*T53;
  v3(14,1)=1;
  v3(14,2)=4988;
  v3(14,3)=  v3(13,3);
  v3(15,1)=1;
  v3(15,2)=6092;
  v3(15,3)=  v3(13,3);
  v3(16,1)=1;
  v3(16,2)=83511;
  v3(16,3)=exp(y(4))*exp(y(1))*T53;
  v3(17,1)=1;
  v3(17,2)=228;
  v3(17,3)=  v3(16,3);
  v3(18,1)=1;
  v3(18,2)=1194;
  v3(18,3)=  v3(16,3);
  v3(19,1)=1;
  v3(19,2)=14718;
  v3(19,3)=  v3(16,3);
  v3(20,1)=1;
  v3(20,2)=15891;
  v3(20,3)=  v3(16,3);
  v3(21,1)=1;
  v3(21,2)=83304;
  v3(21,3)=  v3(16,3);
  v3(22,1)=1;
  v3(22,2)=83514;
  v3(22,3)=T37*T53;
  v3(23,1)=1;
  v3(23,2)=14928;
  v3(23,3)=  v3(22,3);
  v3(24,1)=1;
  v3(24,2)=15894;
  v3(24,3)=  v3(22,3);
  v3(25,1)=1;
  v3(25,2)=84491;
  v3(25,3)=exp(y(4))*exp(y(1))*T83;
  v3(26,1)=1;
  v3(26,2)=1208;
  v3(26,3)=  v3(25,3);
  v3(27,1)=1;
  v3(27,2)=83318;
  v3(27,3)=  v3(25,3);
  v3(28,1)=1;
  v3(28,2)=84492;
  v3(28,3)=(-exp(y(2)))*T83;
  v3(29,1)=1;
  v3(29,2)=6108;
  v3(29,3)=  v3(28,3);
  v3(30,1)=1;
  v3(30,2)=83388;
  v3(30,3)=  v3(28,3);
  v3(31,1)=1;
  v3(31,2)=84494;
  v3(31,3)=T37*T83;
  v3(32,1)=1;
  v3(32,2)=15908;
  v3(32,3)=  v3(31,3);
  v3(33,1)=1;
  v3(33,2)=83528;
  v3(33,3)=  v3(31,3);
  v3(34,1)=1;
  v3(34,2)=84508;
  v3(34,3)=(T37-exp(y(2)))*(T78*T80+T52*(-(params(9)*(T75+T74+exp(y(18))*(T73+exp(y(18))*exp(y(18))*getPowerDeriv(exp(y(18)),1+params(8),3)))/(1+params(8))))+T78*T80+T51*T139);
  v3(35,1)=1;
  v3(35,2)=88201;
  v3(35,3)=exp(y(4))*exp(y(1))*exp(y(19))*T52;
  v3(36,1)=1;
  v3(36,2)=19;
  v3(36,3)=  v3(35,3);
  v3(37,1)=1;
  v3(37,2)=1261;
  v3(37,3)=  v3(35,3);
  v3(38,1)=1;
  v3(38,2)=88272;
  v3(38,3)=(-exp(y(2)))*exp(y(19))*T52;
  v3(39,1)=1;
  v3(39,2)=4989;
  v3(39,3)=  v3(38,3);
  v3(40,1)=1;
  v3(40,2)=6162;
  v3(40,3)=  v3(38,3);
  v3(41,1)=1;
  v3(41,2)=88411;
  v3(41,3)=exp(y(4))*exp(y(1))*exp(y(19))*T52;
  v3(42,1)=1;
  v3(42,2)=229;
  v3(42,3)=  v3(41,3);
  v3(43,1)=1;
  v3(43,2)=1264;
  v3(43,3)=  v3(41,3);
  v3(44,1)=1;
  v3(44,2)=14719;
  v3(44,3)=  v3(41,3);
  v3(45,1)=1;
  v3(45,2)=15961;
  v3(45,3)=  v3(41,3);
  v3(46,1)=1;
  v3(46,2)=88204;
  v3(46,3)=  v3(41,3);
  v3(47,1)=1;
  v3(47,2)=88414;
  v3(47,3)=T37*exp(y(19))*T52;
  v3(48,1)=1;
  v3(48,2)=14929;
  v3(48,3)=  v3(47,3);
  v3(49,1)=1;
  v3(49,2)=15964;
  v3(49,3)=  v3(47,3);
  v3(50,1)=1;
  v3(50,2)=89391;
  v3(50,3)=exp(y(4))*exp(y(1))*exp(y(19))*T80;
  v3(51,1)=1;
  v3(51,2)=1209;
  v3(51,3)=  v3(50,3);
  v3(52,1)=1;
  v3(52,2)=1278;
  v3(52,3)=  v3(50,3);
  v3(53,1)=1;
  v3(53,2)=83319;
  v3(53,3)=  v3(50,3);
  v3(54,1)=1;
  v3(54,2)=84561;
  v3(54,3)=  v3(50,3);
  v3(55,1)=1;
  v3(55,2)=88218;
  v3(55,3)=  v3(50,3);
  v3(56,1)=1;
  v3(56,2)=89392;
  v3(56,3)=(-exp(y(2)))*exp(y(19))*T80;
  v3(57,1)=1;
  v3(57,2)=6109;
  v3(57,3)=  v3(56,3);
  v3(58,1)=1;
  v3(58,2)=6178;
  v3(58,3)=  v3(56,3);
  v3(59,1)=1;
  v3(59,2)=83389;
  v3(59,3)=  v3(56,3);
  v3(60,1)=1;
  v3(60,2)=84562;
  v3(60,3)=  v3(56,3);
  v3(61,1)=1;
  v3(61,2)=88288;
  v3(61,3)=  v3(56,3);
  v3(62,1)=1;
  v3(62,2)=89394;
  v3(62,3)=T37*exp(y(19))*T80;
  v3(63,1)=1;
  v3(63,2)=15909;
  v3(63,3)=  v3(62,3);
  v3(64,1)=1;
  v3(64,2)=15978;
  v3(64,3)=  v3(62,3);
  v3(65,1)=1;
  v3(65,2)=83529;
  v3(65,3)=  v3(62,3);
  v3(66,1)=1;
  v3(66,2)=84564;
  v3(66,3)=  v3(62,3);
  v3(67,1)=1;
  v3(67,2)=88428;
  v3(67,3)=  v3(62,3);
  v3(68,1)=1;
  v3(68,2)=89408;
  v3(68,3)=(T37-exp(y(2)))*exp(y(19))*T139;
  v3(69,1)=1;
  v3(69,2)=84509;
  v3(69,3)=  v3(68,3);
  v3(70,1)=1;
  v3(70,2)=84578;
  v3(70,3)=  v3(68,3);
  v3(71,1)=1;
  v3(71,2)=89461;
  v3(71,3)=exp(y(4))*exp(y(1))*T92;
  v3(72,1)=1;
  v3(72,2)=1279;
  v3(72,3)=  v3(71,3);
  v3(73,1)=1;
  v3(73,2)=88219;
  v3(73,3)=  v3(71,3);
  v3(74,1)=1;
  v3(74,2)=89462;
  v3(74,3)=(-exp(y(2)))*T92;
  v3(75,1)=1;
  v3(75,2)=6179;
  v3(75,3)=  v3(74,3);
  v3(76,1)=1;
  v3(76,2)=88289;
  v3(76,3)=  v3(74,3);
  v3(77,1)=1;
  v3(77,2)=89464;
  v3(77,3)=T37*T92;
  v3(78,1)=1;
  v3(78,2)=15979;
  v3(78,3)=  v3(77,3);
  v3(79,1)=1;
  v3(79,2)=88429;
  v3(79,3)=  v3(77,3);
  v3(80,1)=1;
  v3(80,2)=89478;
  v3(80,3)=(T37-exp(y(2)))*(exp(y(19))*T80+exp(y(19))*exp(y(19))*T136);
  v3(81,1)=1;
  v3(81,2)=84579;
  v3(81,3)=  v3(80,3);
  v3(82,1)=1;
  v3(82,2)=89409;
  v3(82,3)=  v3(80,3);
  v3(83,1)=1;
  v3(83,2)=89479;
  v3(83,3)=(T37-exp(y(2)))*(T92+exp(y(19))*exp(y(19))*T79+exp(y(19))*(exp(y(19))*T79+exp(y(19))*exp(y(19))*T135));
  v3(84,1)=1;
  v3(84,2)=112914;
  v3(84,3)=T21*T62;
  v3(85,1)=1;
  v3(85,2)=14934;
  v3(85,3)=  v3(84,3);
  v3(86,1)=1;
  v3(86,2)=16314;
  v3(86,3)=  v3(84,3);
  v3(87,1)=1;
  v3(87,2)=113894;
  v3(87,3)=T53*T62;
  v3(88,1)=1;
  v3(88,2)=15914;
  v3(88,3)=  v3(87,3);
  v3(89,1)=1;
  v3(89,2)=16328;
  v3(89,3)=  v3(87,3);
  v3(90,1)=1;
  v3(90,2)=83534;
  v3(90,3)=  v3(87,3);
  v3(91,1)=1;
  v3(91,2)=84914;
  v3(91,3)=  v3(87,3);
  v3(92,1)=1;
  v3(92,2)=112928;
  v3(92,3)=  v3(87,3);
  v3(93,1)=1;
  v3(93,2)=113908;
  v3(93,3)=T62*T83;
  v3(94,1)=1;
  v3(94,2)=84514;
  v3(94,3)=  v3(93,3);
  v3(95,1)=1;
  v3(95,2)=84928;
  v3(95,3)=  v3(93,3);
  v3(96,1)=1;
  v3(96,2)=113964;
  v3(96,3)=exp(y(19))*T52*T62;
  v3(97,1)=1;
  v3(97,2)=15984;
  v3(97,3)=  v3(96,3);
  v3(98,1)=1;
  v3(98,2)=16329;
  v3(98,3)=  v3(96,3);
  v3(99,1)=1;
  v3(99,2)=88434;
  v3(99,3)=  v3(96,3);
  v3(100,1)=1;
  v3(100,2)=89814;
  v3(100,3)=  v3(96,3);
  v3(101,1)=1;
  v3(101,2)=112929;
  v3(101,3)=  v3(96,3);
  v3(102,1)=1;
  v3(102,2)=113978;
  v3(102,3)=T62*exp(y(19))*T80;
  v3(103,1)=1;
  v3(103,2)=84584;
  v3(103,3)=  v3(102,3);
  v3(104,1)=1;
  v3(104,2)=84929;
  v3(104,3)=  v3(102,3);
  v3(105,1)=1;
  v3(105,2)=89414;
  v3(105,3)=  v3(102,3);
  v3(106,1)=1;
  v3(106,2)=89828;
  v3(106,3)=  v3(102,3);
  v3(107,1)=1;
  v3(107,2)=113909;
  v3(107,3)=  v3(102,3);
  v3(108,1)=1;
  v3(108,2)=113979;
  v3(108,3)=T62*T92;
  v3(109,1)=1;
  v3(109,2)=89484;
  v3(109,3)=  v3(108,3);
  v3(110,1)=1;
  v3(110,2)=89829;
  v3(110,3)=  v3(108,3);
  v3(111,1)=1;
  v3(111,2)=114314;
  v3(111,3)=T21*T102;
  v3(112,1)=1;
  v3(112,2)=16334;
  v3(112,3)=  v3(111,3);
  v3(113,1)=1;
  v3(113,2)=112934;
  v3(113,3)=  v3(111,3);
  v3(114,1)=1;
  v3(114,2)=114328;
  v3(114,3)=T53*T102;
  v3(115,1)=1;
  v3(115,2)=84934;
  v3(115,3)=  v3(114,3);
  v3(116,1)=1;
  v3(116,2)=113914;
  v3(116,3)=  v3(114,3);
  v3(117,1)=1;
  v3(117,2)=114329;
  v3(117,3)=exp(y(19))*T52*T102;
  v3(118,1)=1;
  v3(118,2)=89834;
  v3(118,3)=  v3(117,3);
  v3(119,1)=1;
  v3(119,2)=113984;
  v3(119,3)=  v3(117,3);
  v3(120,1)=1;
  v3(120,2)=114334;
  v3(120,3)=T21*(-(exp(y(4))*params(6)*((-T31)*T58+T31*T97+T31*T97+(-T31)*T171)));
  v3(121,1)=1;
  v3(121,2)=147214;
  v3(121,3)=T21*T67;
  v3(122,1)=1;
  v3(122,2)=14941;
  v3(122,3)=  v3(121,3);
  v3(123,1)=1;
  v3(123,2)=16804;
  v3(123,3)=  v3(121,3);
  v3(124,1)=1;
  v3(124,2)=148194;
  v3(124,3)=T53*T67;
  v3(125,1)=1;
  v3(125,2)=15921;
  v3(125,3)=  v3(124,3);
  v3(126,1)=1;
  v3(126,2)=16818;
  v3(126,3)=  v3(124,3);
  v3(127,1)=1;
  v3(127,2)=83541;
  v3(127,3)=  v3(124,3);
  v3(128,1)=1;
  v3(128,2)=85404;
  v3(128,3)=  v3(124,3);
  v3(129,1)=1;
  v3(129,2)=147228;
  v3(129,3)=  v3(124,3);
  v3(130,1)=1;
  v3(130,2)=148208;
  v3(130,3)=T67*T83;
  v3(131,1)=1;
  v3(131,2)=84521;
  v3(131,3)=  v3(130,3);
  v3(132,1)=1;
  v3(132,2)=85418;
  v3(132,3)=  v3(130,3);
  v3(133,1)=1;
  v3(133,2)=148264;
  v3(133,3)=exp(y(19))*T52*T67;
  v3(134,1)=1;
  v3(134,2)=15991;
  v3(134,3)=  v3(133,3);
  v3(135,1)=1;
  v3(135,2)=16819;
  v3(135,3)=  v3(133,3);
  v3(136,1)=1;
  v3(136,2)=88441;
  v3(136,3)=  v3(133,3);
  v3(137,1)=1;
  v3(137,2)=90304;
  v3(137,3)=  v3(133,3);
  v3(138,1)=1;
  v3(138,2)=147229;
  v3(138,3)=  v3(133,3);
  v3(139,1)=1;
  v3(139,2)=148278;
  v3(139,3)=T67*exp(y(19))*T80;
  v3(140,1)=1;
  v3(140,2)=84591;
  v3(140,3)=  v3(139,3);
  v3(141,1)=1;
  v3(141,2)=85419;
  v3(141,3)=  v3(139,3);
  v3(142,1)=1;
  v3(142,2)=89421;
  v3(142,3)=  v3(139,3);
  v3(143,1)=1;
  v3(143,2)=90318;
  v3(143,3)=  v3(139,3);
  v3(144,1)=1;
  v3(144,2)=148209;
  v3(144,3)=  v3(139,3);
  v3(145,1)=1;
  v3(145,2)=148279;
  v3(145,3)=T67*T92;
  v3(146,1)=1;
  v3(146,2)=89491;
  v3(146,3)=  v3(145,3);
  v3(147,1)=1;
  v3(147,2)=90319;
  v3(147,3)=  v3(145,3);
  v3(148,1)=1;
  v3(148,2)=148614;
  v3(148,3)=T21*T110;
  v3(149,1)=1;
  v3(149,2)=16341;
  v3(149,3)=  v3(148,3);
  v3(150,1)=1;
  v3(150,2)=16824;
  v3(150,3)=  v3(148,3);
  v3(151,1)=1;
  v3(151,2)=112941;
  v3(151,3)=  v3(148,3);
  v3(152,1)=1;
  v3(152,2)=114804;
  v3(152,3)=  v3(148,3);
  v3(153,1)=1;
  v3(153,2)=147234;
  v3(153,3)=  v3(148,3);
  v3(154,1)=1;
  v3(154,2)=148628;
  v3(154,3)=T53*T110;
  v3(155,1)=1;
  v3(155,2)=84941;
  v3(155,3)=  v3(154,3);
  v3(156,1)=1;
  v3(156,2)=85424;
  v3(156,3)=  v3(154,3);
  v3(157,1)=1;
  v3(157,2)=113921;
  v3(157,3)=  v3(154,3);
  v3(158,1)=1;
  v3(158,2)=114818;
  v3(158,3)=  v3(154,3);
  v3(159,1)=1;
  v3(159,2)=148214;
  v3(159,3)=  v3(154,3);
  v3(160,1)=1;
  v3(160,2)=148629;
  v3(160,3)=exp(y(19))*T52*T110;
  v3(161,1)=1;
  v3(161,2)=89841;
  v3(161,3)=  v3(160,3);
  v3(162,1)=1;
  v3(162,2)=90324;
  v3(162,3)=  v3(160,3);
  v3(163,1)=1;
  v3(163,2)=113991;
  v3(163,3)=  v3(160,3);
  v3(164,1)=1;
  v3(164,2)=114819;
  v3(164,3)=  v3(160,3);
  v3(165,1)=1;
  v3(165,2)=148284;
  v3(165,3)=  v3(160,3);
  v3(166,1)=1;
  v3(166,2)=148634;
  v3(166,3)=T21*(-(exp(y(4))*params(6)*(T31*T58+(-T31)*T97+(-T31)*T97+T31*T171)));
  v3(167,1)=1;
  v3(167,2)=114341;
  v3(167,3)=  v3(166,3);
  v3(168,1)=1;
  v3(168,2)=114824;
  v3(168,3)=  v3(166,3);
  v3(169,1)=1;
  v3(169,2)=149104;
  v3(169,3)=T21*T117;
  v3(170,1)=1;
  v3(170,2)=16831;
  v3(170,3)=  v3(169,3);
  v3(171,1)=1;
  v3(171,2)=147241;
  v3(171,3)=  v3(169,3);
  v3(172,1)=1;
  v3(172,2)=149118;
  v3(172,3)=T53*T117;
  v3(173,1)=1;
  v3(173,2)=85431;
  v3(173,3)=  v3(172,3);
  v3(174,1)=1;
  v3(174,2)=148221;
  v3(174,3)=  v3(172,3);
  v3(175,1)=1;
  v3(175,2)=149119;
  v3(175,3)=exp(y(19))*T52*T117;
  v3(176,1)=1;
  v3(176,2)=90331;
  v3(176,3)=  v3(175,3);
  v3(177,1)=1;
  v3(177,2)=148291;
  v3(177,3)=  v3(175,3);
  v3(178,1)=1;
  v3(178,2)=149124;
  v3(178,3)=T21*(-(exp(y(4))*params(6)*((-T31)*T58+T31*T97+(-T31)*T31*T96+T31*(T97+T31*T169))));
  v3(179,1)=1;
  v3(179,2)=114831;
  v3(179,3)=  v3(178,3);
  v3(180,1)=1;
  v3(180,2)=148641;
  v3(180,3)=  v3(178,3);
  v3(181,1)=1;
  v3(181,2)=149131;
  v3(181,3)=T21*(-(exp(y(4))*params(6)*(T31*T58+T31*T31*T96+T31*T31*T96+T31*(T31*T96+T31*T31*T168))));
  g3 = sparse(v3(:,1),v3(:,2),v3(:,3),1,343000);
end
end
end
end
